/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.client.CloudRequest;
import com.tplink.eap.cloudsdk.client.ConnectionStatus;
import com.tplink.eap.cloudsdk.client.ConnectionType;
import com.tplink.eap.cloudsdk.client.HelloCloudDelegate;
import com.tplink.eap.cloudsdk.client.IResponseDelegate;
import com.tplink.eap.cloudsdk.client.ReconnectionEvent;
import com.tplink.eap.cloudsdk.client.SEFClient;
import com.tplink.eap.cloudsdk.client.ServiceClient;
import com.tplink.eap.cloudsdk.client.StopConnReason;
import com.tplink.eap.cloudsdk.util.FourTuple;
import com.tplink.eap.cloudsdk.util.TwoTuple;
import java.io.IOException;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudClient.class);
    private final HelloCloudDelegate helloCloudDelegate;
    private final boolean keepPersistentConnection;
    private AtomicReference<ConnectionType> connType = new AtomicReference();
    private SEFClient sefClient;
    private ServiceClient svrClient;
    private AtomicReference<Thread> startupThread = new AtomicReference();
    private AtomicReference<ConnectionPhase> connPhase = new AtomicReference<ConnectionPhase>(ConnectionPhase.SEF_SERVER);
    private int connectMaxWaitingTimeMs = 35000;
    private int connectCheckIntervalMs = 500;

    public CloudClient(HelloCloudDelegate helloCloudDelegate, Map<String, CloudRequest> requestMap, boolean keepPersistentConnection) {
        this.helloCloudDelegate = helloCloudDelegate;
        this.keepPersistentConnection = keepPersistentConnection;
        this.sefClient = new SEFClient(helloCloudDelegate);
        this.svrClient = new ServiceClient(helloCloudDelegate, requestMap);
    }

    public synchronized void start() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                logger.info("CloudClient is started.");
                try {
                    block17: while (!Thread.currentThread().isInterrupted()) {
                        CloudClient.this.connPhase.set(ConnectionPhase.SEF_SERVER);
                        try {
                            FourTuple<Boolean, String, Integer, Integer> sefConnRslt;
                            CloudClient.this.svrClient.restoreDefaultServerConfig();
                            try {
                                logger.info("Connect SEF server automatically.");
                                sefConnRslt = CloudClient.this.sefClient.autoConnect();
                            }
                            finally {
                                logger.info("Close connection to SEF server.");
                                CloudClient.this.sefClient.close();
                            }
                            if (((Boolean)sefConnRslt.first).booleanValue() && !StringUtils.isEmpty((String)((String)sefConnRslt.second)) && (Integer)sefConnRslt.third > 0) {
                                CloudClient.this.svrClient.updateServerConfig((String)sefConnRslt.second, (Integer)sefConnRslt.third, (Integer)sefConnRslt.fourth);
                            }
                            CloudClient.this.connPhase.set(ConnectionPhase.SERVICE_SERVER);
                            while (!Thread.currentThread().isInterrupted()) {
                                ServiceClient serviceClient;
                                block25: {
                                    try {
                                        CloudClient.this.connType.set(CloudClient.this.getConnType());
                                        logger.info("Connect service server automatically, ConnectionType is {}.", (Object)CloudClient.this.connType);
                                        TwoTuple<Boolean, Boolean> svrConnRslt = CloudClient.this.svrClient.autoConnect((ConnectionType)((Object)CloudClient.this.connType.get()));
                                        if (Thread.currentThread().isInterrupted()) break block25;
                                        if (!((Boolean)svrConnRslt.first).booleanValue() && ((Boolean)svrConnRslt.second).booleanValue()) continue block17;
                                        serviceClient = CloudClient.this.svrClient;
                                        synchronized (serviceClient) {
                                            if (((ConnectionType)((Object)CloudClient.this.connType.get())).equals((Object)ConnectionType.PERSISTENT_CONNECTION)) {
                                                if (((Boolean)svrConnRslt.first).booleanValue()) {
                                                    CloudClient.this.svrClient.wait();
                                                }
                                            } else {
                                                CloudClient.this.svrClient.wait(CloudClient.this.svrClient.getNoaccountReconnectIntervalMs());
                                            }
                                        }
                                    }
                                    finally {
                                        logger.info("Close connection to service server.");
                                        CloudClient.this.svrClient.close();
                                    }
                                }
                                TwoTuple<StopConnReason, Integer> parseRslt = CloudClient.this.svrClient.parseClosedReason();
                                if (((StopConnReason)((Object)parseRslt.first)).equals((Object)StopConnReason.RECONNECT_SEF)) {
                                    logger.info("CloudClient will reconnects SEF server.");
                                    continue block17;
                                }
                                if ((Integer)parseRslt.second <= 0) continue;
                                logger.debug("CloudClient will reconnects service server after {}.", parseRslt.second);
                                serviceClient = CloudClient.this.svrClient;
                                synchronized (serviceClient) {
                                    CloudClient.this.svrClient.setConnStatus(ConnectionStatus.DISCONNECTED_FORBIDDEN);
                                    CloudClient.this.svrClient.wait(((Integer)parseRslt.second).intValue());
                                    CloudClient.this.svrClient.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            logger.debug(e.toString(), (Throwable)e);
                            logger.info("'startupThread' is interrupted.");
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception:{}", (Object)e.toString());
                    logger.debug("Exception stack trace:{}", (Throwable)e);
                }
                logger.info("'startupThread' is stopped.");
            }
        });
        thread.setDaemon(true);
        thread.start();
        this.startupThread.set(thread);
    }

    public synchronized void stop() {
        logger.debug("Tries to stop CloudClient.");
        Thread lastStartupThread = this.startupThread.get();
        if (lastStartupThread != null) {
            lastStartupThread.interrupt();
            if (this.sefClient != null) {
                this.sefClient.close();
            }
            if (this.svrClient != null) {
                this.svrClient.close();
            }
            while (lastStartupThread.isAlive()) {
                logger.debug("'startupThread' is stopping.");
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    logger.warn(e.toString(), (Throwable)e);
                }
            }
        }
        logger.info("CloudClient is stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestAsync(JSONObject request, IResponseDelegate delegate, boolean reconnect) {
        if (reconnect && !this.svrClient.getConnStatus().equals((Object)ConnectionStatus.CONNECTED)) {
            try {
                this.notifyReconnect(this.connectMaxWaitingTimeMs);
            }
            catch (InterruptedException e) {
                logger.info(e.toString(), (Throwable)e);
                delegate.onResponse(this.createGenericErrorResponse());
                return;
            }
        }
        ServiceClient serviceClient = this.svrClient;
        synchronized (serviceClient) {
            try {
                if (this.svrClient.getConnStatus().equals((Object)ConnectionStatus.CONNECTED)) {
                    this.svrClient.send(request, delegate);
                } else {
                    delegate.onResponse(this.createGenericErrorResponse());
                }
            }
            catch (SocketException e) {
                logger.info(e.toString(), (Throwable)e);
                if (this.connType.get().equals((Object)ConnectionType.PERSISTENT_CONNECTION)) {
                    this.svrClient.notifyAll();
                }
                delegate.onResponse(this.createGenericErrorResponse());
            }
            catch (IOException e) {
                logger.warn(e.toString(), (Throwable)e);
                delegate.onResponse(this.createGenericErrorResponse());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendRequestSync(JSONObject request, boolean reconnect) {
        JSONObject response = null;
        if (reconnect && !this.svrClient.getConnStatus().equals((Object)ConnectionStatus.CONNECTED)) {
            try {
                this.notifyReconnect(this.connectMaxWaitingTimeMs);
            }
            catch (InterruptedException e) {
                logger.info(e.toString(), (Throwable)e);
                return this.createGenericErrorResponse();
            }
        }
        ServiceClient serviceClient = this.svrClient;
        synchronized (serviceClient) {
            try {
                if (this.svrClient.getConnStatus().equals((Object)ConnectionStatus.CONNECTED)) {
                    response = this.svrClient.send(request);
                }
            }
            catch (SocketException e) {
                if (this.connType.get().equals((Object)ConnectionType.PERSISTENT_CONNECTION)) {
                    this.svrClient.notifyAll();
                }
                logger.info(e.toString(), (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.info(e.toString(), (Throwable)e);
            }
            catch (IOException e) {
                logger.warn(e.toString(), (Throwable)e);
            }
        }
        if (response == null) {
            response = this.createGenericErrorResponse();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyEvent(ReconnectionEvent event) {
        boolean reconnectionIsTriggered = false;
        ConnectionStatus connStatus = this.getConnectionStatus();
        logger.debug("Received reconnectionEvent is {}.", (Object)event);
        if (event.equals((Object)ReconnectionEvent.NON_USER_REQUEST_TIMEOUT_THREE_TIMES) || event.equals((Object)ReconnectionEvent.WAN_IP_CHANGED) || event.equals((Object)ReconnectionEvent.LAN_IP_CHANGED)) {
            if (!connStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN)) {
                reconnectionIsTriggered = true;
                this.nofityReconnect();
            }
        } else if (event.equals((Object)ReconnectionEvent.USER_REQUEST_TIMEOUT_TWO_TIMES) || event.equals((Object)ReconnectionEvent.RECOVER_CONNECTION)) {
            reconnectionIsTriggered = true;
            this.nofityReconnect();
        } else if (event.equals((Object)ReconnectionEvent.DEVICE_BINDED) || event.equals((Object)ReconnectionEvent.DEVICE_UNBOUND)) {
            reconnectionIsTriggered = true;
            CloudClient cloudClient = this;
            synchronized (cloudClient) {
                this.stop();
                this.start();
            }
        } else {
            logger.error("Unexpected reconnection event.");
        }
        return reconnectionIsTriggered;
    }

    public ConnectionStatus getConnectionStatus() {
        ConnectionStatus sefStatus = this.sefClient.getConnStatus();
        ConnectionStatus svrStatus = this.svrClient.getConnStatus();
        if (svrStatus.equals((Object)ConnectionStatus.CONNECTED)) {
            return ConnectionStatus.CONNECTED;
        }
        if (sefStatus.equals((Object)ConnectionStatus.CONNECTING) || svrStatus.equals((Object)ConnectionStatus.CONNECTING)) {
            return ConnectionStatus.CONNECTING;
        }
        if (sefStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN) || svrStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN)) {
            return ConnectionStatus.DISCONNECTED_FORBIDDEN;
        }
        return ConnectionStatus.DISCONNECTED_NORMAL;
    }

    public ConnectionType getConnectionType() {
        return this.connType.get();
    }

    public boolean isRunning() {
        if (this.startupThread.get() == null) {
            return false;
        }
        return this.startupThread.get().isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReconnect(int waitTimeMs) throws InterruptedException {
        long currentTimestamp;
        long waitingEndTimestamp = System.currentTimeMillis() + (long)waitTimeMs;
        if (this.connPhase.get().equals((Object)ConnectionPhase.SEF_SERVER)) {
            SEFClient sEFClient = this.sefClient;
            synchronized (sEFClient) {
                logger.trace("Tries to skip the phase of connecting SEF server.");
                this.sefClient.setSkipped(true);
                this.sefClient.notifyAll();
            }
        }
        ServiceClient serviceClient = this.svrClient;
        synchronized (serviceClient) {
            ConnectionStatus svrConnStatus = this.svrClient.getConnStatus();
            if (svrConnStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN) || svrConnStatus.equals((Object)ConnectionStatus.DISCONNECTED_NORMAL)) {
                this.svrClient.notifyAll();
            }
        }
        do {
            logger.trace("Sleep...");
            Thread.sleep(this.connectCheckIntervalMs);
            currentTimestamp = System.currentTimeMillis();
        } while (this.svrClient.getConnStatus().equals((Object)ConnectionStatus.CONNECTING) && currentTimestamp <= waitingEndTimestamp);
        logger.trace("svrClient.getConnStatus() is {}", (Object)this.svrClient.getConnStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nofityReconnect() {
        if (this.connPhase.get().equals((Object)ConnectionPhase.SEF_SERVER)) {
            SEFClient sEFClient = this.sefClient;
            synchronized (sEFClient) {
                this.sefClient.notifyAll();
            }
        }
        ServiceClient serviceClient = this.svrClient;
        synchronized (serviceClient) {
            this.svrClient.notifyAll();
        }
    }

    private JSONObject createGenericErrorResponse() {
        JSONObject response = new JSONObject();
        response.put((Object)"error_code", (Object)-10000);
        return response;
    }

    private ConnectionType getConnType() {
        if (this.keepPersistentConnection) {
            return ConnectionType.PERSISTENT_CONNECTION;
        }
        DeviceInfo deviceInfo = this.helloCloudDelegate.getDeviceInfoMgmt().getDeviceInfo();
        if (StringUtils.isBlank((String)deviceInfo.getCloudUserName())) {
            return ConnectionType.SHORT_CONNECTION;
        }
        return ConnectionType.PERSISTENT_CONNECTION;
    }

    private static enum ConnectionPhase {
        SEF_SERVER,
        SERVICE_SERVER;

    }
}

